#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <unistd.h>
#include <string.h>
#include <time.h>

#define N_THREAD 15

#define AUTOMOBIL 1
#define AUTOBUS 2
#define KAMION 3

pthread_mutex_t mutex = PTHREAD_MUTEX_INITIALIZER;
pthread_cond_t cond = PTHREAD_COND_INITIALIZER;

int smer = -1;

int brAutobusa = 0;
int brKamiona = 0;
int brAutomobila = 0;

int trenutno_stanje = 0;

typedef struct argument{
    long id;
    int tip;
    int smer;
}argument;


void *nadvoznjak(void *a){

    argument *arg = (argument *)a;

    char vozilo[20]; // Zbog preglednosti
    if(arg->tip == AUTOBUS) strcpy(vozilo, "AUTOBUS");
    else if(arg->tip == KAMION) strcpy(vozilo, "KAMION");
    else strcpy(vozilo, "AUTOMOBIL");


    sleep(rand() % 4 + 1); // Koristio sam rand(), ali moze i srand(seed)
    
    
    printf("%s ID = %ld, smer = %d, pristigao\n", vozilo, arg->id, arg->smer);

    pthread_mutex_lock(&mutex);
    while(
            brKamiona > 0 // Ako je kamion na nadvoznjaku onda svi ostali moraju da sacekaju, ondosno nemaju pristup
            || (arg->tip == AUTOBUS && brAutobusa > 0)  // Ako sam ja Autobus i na mostu ima vise od 0 autobusa ja nemam pristup
            || (smer != -1 && smer != arg->smer) // Ako je suprotan smer ja nemam pristup
            || (trenutno_stanje > 0 && arg->tip == KAMION)){ // Ako sam ja kamion, a na nadvoznjaku ima barem jedno vozilo, onda nemam pristup
        pthread_cond_wait(&cond, &mutex);
    }

    if(arg->tip == AUTOMOBIL) brAutomobila++;
    else if(arg->tip == KAMION) brKamiona++;
    else brAutobusa++;

    trenutno_stanje++;
    smer = arg->smer; // Kada dobije pristup mostu, vozilo postavlja smer

    pthread_mutex_unlock(&mutex);

    printf("%s ID = %ld SMER = %d prelazi preko nadvoznjaka\n", vozilo, arg->id, arg->smer);
    sleep(rand() % 3);

    pthread_mutex_lock(&mutex);

    trenutno_stanje--;

    if(arg->tip == AUTOMOBIL) brAutomobila--;
    else if(arg->tip == KAMION) brKamiona--;
    else brAutobusa--;

    if(trenutno_stanje == 0) smer = -1;// Ako sam ja poslednje vozilo onda smer ide na neutralni i sledece vozilo ga postavlja

    pthread_cond_broadcast(&cond);
    pthread_mutex_unlock(&mutex);

    printf("%s %ld je presao nadvoznjak\n", vozilo, arg->id);
    
    return NULL;
}


int main(){
    pthread_t threadovi[N_THREAD];
    argument argumenti[N_THREAD];
    for(long i = 0; i < N_THREAD; i++){
        argumenti[i].id = i;
        argumenti[i].tip = rand() % 3 + 1;
        argumenti[i].smer = rand() % 2;
        pthread_create(threadovi + i, NULL, nadvoznjak, (void *)&argumenti[i]);
    }
    for(long i = 0; i < N_THREAD; i++){
        pthread_join(threadovi[i], NULL);
    }
    pthread_exit(NULL);
}